/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.every_compat.modules.project_brazier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dark_roleplay.marg.client.generators.textures.generator.TextureGenerator;
import net.dark_roleplay.marg.common.material.MargMaterial;
import net.dark_roleplay.marg.common.material.MaterialCondition;
import net.dark_roleplay.marg.common.material.MaterialProperties;
import net.dark_roleplay.projectbrazier.feature.blocks.templates.HAxisDecoBlock;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierBlocks;
import net.dark_roleplay.projectbrazier.feature.registrars.BrazierCreativeTabs;
import net.mehvahdjukaar.every_compat.WoodGood;
import net.mehvahdjukaar.every_compat.api.SimpleEntrySet;
import net.mehvahdjukaar.every_compat.api.SimpleModule;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.client.asset_generators.textures.SpriteUtils;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class ProjectBrazierModule
extends SimpleModule {
    public static Map<ResourceLocation, TextureGenerator> generators;
    private static List<MargMaterial> margMaterials;
    public final SimpleEntrySet<WoodType, Block> FIREWOODS = SimpleEntrySet.builder(WoodType.class, "firewood", () -> this.getModBlock("oak_firewood"), () -> WoodType.OAK_WOOD_TYPE, this.ifCond(() -> BrazierBlocks.FIREWOOD_CON, w -> new HAxisDecoBlock(WoodGood.copySafe((BlockBehaviour)w.planks).m_60913_(2.0f, 3.0f).m_60955_(), "full_block"))).addTag(BlockTags.f_144280_, Registry.f_122901_).setTab(BrazierCreativeTabs::decor).defaultRecipe().build();

    public ProjectBrazierModule(String modId) {
        super(modId, "pb");
        this.addEntry(this.FIREWOODS);
    }

    public static void generateStuff(Map<ResourceLocation, TextureGenerator> gen, ResourceManager manager) {
        generators = gen;
        if (margMaterials.isEmpty()) {
            WoodTypeRegistry.WOOD_TYPES.forEach((r, wood) -> {
                if (!wood.isVanilla() && !wood.getNamespace().equals("projectbrazier")) {
                    margMaterials.add(ProjectBrazierModule.makeWoodMaterial(wood, manager));
                }
            });
        }
        try {
            generators.forEach((r, g) -> margMaterials.forEach(arg_0 -> ((TextureGenerator)g).generate(arg_0)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T extends BlockType, B extends Block> Function<T, @Nullable B> ifCond(Supplier<MaterialCondition> cond, Function<T, B> supplier) {
        return w -> {
            List t = ((MaterialCondition)cond.get()).getTextures();
            for (String v : t) {
                if (w.getChild(v) != null) continue;
                return null;
            }
            return (Block)supplier.apply(w);
        };
    }

    public static MargMaterial makeWoodMaterial(WoodType wood, ResourceManager manager) {
        HashMap<String, String> textures = new HashMap<String, String>();
        if (manager != null) {
            ResourceLocation stripped2;
            try {
                stripped2 = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.getBlockOfThis("stripped_log"), SpriteUtils::looksLikeSideLogTexture);
                textures.put("stripped_log", stripped2.toString());
            }
            catch (Exception stripped2) {
                // empty catch block
            }
            try {
                stripped2 = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.getBlockOfThis("stripped_log"), SpriteUtils::looksLikeTopLogTexture);
                textures.put("stripped_log_top", stripped2.toString());
            }
            catch (Exception stripped3) {
                // empty catch block
            }
            try {
                stripped2 = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.getBlockOfThis("log"), SpriteUtils::looksLikeSideLogTexture);
                textures.put("log", stripped2.toString());
            }
            catch (Exception stripped4) {
                // empty catch block
            }
            try {
                stripped2 = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.getBlockOfThis("log"), SpriteUtils::looksLikeTopLogTexture);
                textures.put("log_top", stripped2.toString());
            }
            catch (Exception stripped5) {
                // empty catch block
            }
            try {
                stripped2 = RPUtils.findFirstBlockTextureLocation((ResourceManager)manager, (Block)wood.getBlockOfThis("planks"));
                textures.put("planks", stripped2.toString());
            }
            catch (Exception stripped6) {
                // empty catch block
            }
        }
        Material mat = wood.material;
        Block base = wood.getBlockOfThis("planks");
        HashMap items = new HashMap();
        HashMap blocks = new HashMap();
        wood.getChildren().forEach(e -> {
            Object patt8233$temp = e.getValue();
            if (patt8233$temp instanceof Block) {
                Block b = (Block)patt8233$temp;
                blocks.put((String)e.getKey(), b.getRegistryName().toString());
            } else {
                items.put((String)e.getKey(), ((ItemLike)e.getValue()).m_5456_().getRegistryName().toString());
            }
        });
        MaterialProperties prop = new MaterialProperties(Float.valueOf(1.0f), Float.valueOf(1.0f), Integer.valueOf(0), base.m_49958_(), 0, List.of("axe"), mat.m_76339_());
        return new MargMaterial("wood", wood.getAppendableId(), "everycomp", prop, textures, blocks, items);
    }

    static {
        margMaterials = new ArrayList<MargMaterial>();
    }
}

